-- @lex Guestbook Backup
-- version 4.0.5
-- By Alexis Soulard (c)
-- http://www.alexguestbook.net
-- Date : 10/01/2008 12:30:57

DROP TABLE IF EXISTS `appel_livre_txt_lang`;
DROP TABLE IF EXISTS `appel_livre_sessions`;
DROP TABLE IF EXISTS `appel_livre_users`;
DROP TABLE IF EXISTS `appel_livre_messages`;
DROP TABLE IF EXISTS `appel_livre_censure`;
DROP TABLE IF EXISTS `appel_livre_ip`;
DROP TABLE IF EXISTS `appel_livre_smileys`;
DROP TABLE IF EXISTS `appel_livre_img_verif_add`;

CREATE TABLE `appel_livre_censure` (
  `id_mot` mediumint(11) unsigned NOT NULL auto_increment,
  `texte_censure` varchar(255) NOT NULL default '',
  `texte_remplace` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id_mot`)
) TYPE=MyISAM;

CREATE TABLE `appel_livre_ip` (
  `id_ip` mediumint(11) unsigned NOT NULL auto_increment,
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id_ip`)
) TYPE=MyISAM;

CREATE TABLE `appel_livre_messages` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `nom` varchar(40) NOT NULL default '',
  `email` varchar(150) NOT NULL default '',
  `site` varchar(150) NOT NULL default '',
  `ville_pays` varchar(60) NOT NULL default '',
  `pays` varchar(2) NOT NULL,
  `note` char(2) default NULL,
  `message` text NOT NULL,
  `titre_reponse` varchar(100) NOT NULL,
  `reponse` text NOT NULL,
  `time` int(11) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `valid` enum('yes','no') NOT NULL default 'yes',
  PRIMARY KEY  (`id`),
  KEY `time` (`time`),
  KEY `valid` (`valid`), 
  KEY `nom` (`nom`), 
  FULLTEXT KEY `message` (`message`)
) TYPE=MyISAM;

CREATE TABLE `appel_livre_sessions` (
  `session` varchar(70) NOT NULL default '',
  `id_user` mediumint(11) unsigned NOT NULL default '0',
  `login` varchar(20) NOT NULL default '',
  `last_connect` int(15) NOT NULL default '0',
  KEY `session` (`session`)
) TYPE=MyISAM;

CREATE TABLE `appel_livre_smileys` (
  `id_smiley` mediumint(11) unsigned NOT NULL auto_increment,
  `numero` mediumint(8) unsigned NOT NULL default '0',
  `smiley` varchar(255) NOT NULL default '',
  `car_replace` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`id_smiley`),
  KEY `numero` (`numero`)
) TYPE=MyISAM;


CREATE TABLE `appel_livre_users` (
  `id_user` mediumint(11) unsigned NOT NULL auto_increment,
  `login` varchar(20) NOT NULL default '',
  `pass` varchar(10) binary NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `receive_email` tinyint(1) NOT NULL default '0',
  `modif_options` tinyint(1) NOT NULL default '0',
  `gestion_skins` tinyint(1) NOT NULL default '0',
  `gestion_reponse_auto` tinyint(1) NOT NULL default '0',
  `gestion_bdd` tinyint(1) NOT NULL default '0',
  `gestion_messages` tinyint(1) NOT NULL default '0',
  `gestion_censure` tinyint(1) NOT NULL default '0',
  `gestion_ip` tinyint(1) NOT NULL default '0',
  `gestion_smileys` tinyint(1) NOT NULL default '0',
  `gestion_admin` tinyint(1) NOT NULL default '0',
  `nb_mess_page` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_user`),
  KEY `login` (`login`),
  KEY `pass` (`pass`)
) TYPE=MyISAM;


CREATE TABLE `appel_livre_img_verif_add` (
  `numero` varchar(10) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `valeur` varchar(5) NOT NULL default '',
  `nom` varchar(40) NOT NULL default '',
  `email` varchar(150) NOT NULL default '',
  `site` varchar(150) NOT NULL default '',
  `ville_pays` varchar(60) NOT NULL default '',
  `pays` varchar(2) NOT NULL,
  `note` char(2) NOT NULL default '',
  `message` text NOT NULL,
  KEY `time` (`time`),
  KEY `numero` (`numero`)
) TYPE=MyISAM;

CREATE TABLE `appel_livre_txt_lang` (
`lang` VARCHAR(20) NOT NULL,
`type` ENUM('rep_auto', 'titre', 'rep', 'boite'),
`msg` TEXT NOT NULL,
INDEX (`lang`) ,
INDEX (`type`) 
) TYPE=MyISAM;

-- `appel_livre_txt_lang` DATAS

INSERT INTO `appel_livre_txt_lang` VALUES ('francais', 'titre', 'Appel pour les Arbres Vnrables - livre d\'or');
INSERT INTO `appel_livre_txt_lang` VALUES ('english', 'titre', 'Call for Venerable Trees - Guestbook');
INSERT INTO `appel_livre_txt_lang` VALUES ('francais', 'rep_auto', 'Bonjour [PSEUDO],\r\n\r\n\r\nMerci d\'avoir laiss un message en faveur des arbres vnrables!\r\nN\'hsitez pas  en parler autour de vous et d\'envoyer le lien http://arbresvenerables.free.fr\r\nAllez voir la page sur l\'expo des Arbres Vnrables ainsi que le carnet de voyages, mais aussi la page No Comment...\r\n\r\nA bientt de vos nouvelles et si vous voulez crire  Jrme Hutin:\r\narbres-venerables@orange.fr\r\n\r\nJrme.\r\n');
INSERT INTO `appel_livre_txt_lang` VALUES ('english', 'rep_auto', 'Hi [PSEUDO],\r\n\r\nThank you to have left a message in favour of the venerable trees!\r\nDo not hesitate to speak about it around you and to send the link http://arbresvenerables.free.fr \r\nVisit the page of the exhibit of the Venerable Trees as well as the travel stories, but also the No Comment page...\r\n\r\nSee you soon with your news(short stories) and if you want to write to Jrme Hutin:\r\narbres-venerables@orange.fr \r\nJrme.\r\n\r\n');
INSERT INTO `appel_livre_txt_lang` VALUES ('spanish', 'rep_auto', 'Hola [PSEUDO],\r\n\r\nGracias por dejar su mensaje en nuestro libro de visitas!\r\n\r\nThank you to have left a message in favour of the venerable trees!\r\nDo not hesitate to speak about it around you and to send the link http://arbresvenerables.free.fr \r\nVisit the page of the exhibit of the Venerable Trees as well as the travel stories, but also the No Comment page...\r\n\r\nSee you soon with your news(short stories) and if you want to write to Jrme Hutin:\r\narbres-venerables@orange.fr \r\nJrme.');
INSERT INTO `appel_livre_txt_lang` VALUES ('german', 'rep_auto', 'Hi [PSEUDO],\r\n\r\nThank you to have left a message in favour of the venerable trees!\r\nDo not hesitate to speak about it around you and to send the link http://arbresvenerables.free.fr \r\nVisit the page of the exhibit of the Venerable Trees as well as the travel stories, but also the No Comment page...\r\n\r\nSee you soon with your news(short stories) and if you want to write to Jrme Hutin:\r\narbres-venerables@orange.fr \r\nJrme.\r\n\r\n');

-- `appel_livre_sessions` DATAS

INSERT INTO `appel_livre_sessions` VALUES ('1c5a458d3f09f7dd56283ed2d94a017f', '1', 'arbresvenerables', '1199964657');

-- `appel_livre_users` DATAS

INSERT INTO `appel_livre_users` VALUES ('1', 'arbresvenerables', 'mycena', 'arbres-venerables@orange.fr', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '50');

-- `appel_livre_messages` DATAS


-- `appel_livre_censure` DATAS


-- `appel_livre_ip` DATAS


-- `appel_livre_smileys` DATAS

INSERT INTO `appel_livre_smileys` VALUES ('1', '1', 'smile.gif', ':)');
INSERT INTO `appel_livre_smileys` VALUES ('2', '2', 'biggrin.gif', ':-D');
INSERT INTO `appel_livre_smileys` VALUES ('3', '3', 'confused.gif', ':?');
INSERT INTO `appel_livre_smileys` VALUES ('4', '4', 'cool.gif', '8)');
INSERT INTO `appel_livre_smileys` VALUES ('5', '5', 'cry.gif', ':cry:');
INSERT INTO `appel_livre_smileys` VALUES ('6', '6', 'eek.gif', ':shock:');
INSERT INTO `appel_livre_smileys` VALUES ('7', '7', 'love.gif', ':V)');
INSERT INTO `appel_livre_smileys` VALUES ('8', '8', 'mad.gif', ':x');
INSERT INTO `appel_livre_smileys` VALUES ('9', '9', 'lol.gif', ':lol:');
INSERT INTO `appel_livre_smileys` VALUES ('10', '10', 'surprised.gif', '8-O');
INSERT INTO `appel_livre_smileys` VALUES ('11', '11', 'wink.gif', ':;');
INSERT INTO `appel_livre_smileys` VALUES ('12', '12', 'ooops.gif', ':oops:');
INSERT INTO `appel_livre_smileys` VALUES ('13', '13', 'twisted.gif', ':twisted:');
INSERT INTO `appel_livre_smileys` VALUES ('14', '14', 'evil.gif', ':evil:');
INSERT INTO `appel_livre_smileys` VALUES ('15', '15', 'furious.gif', ':GG');
INSERT INTO `appel_livre_smileys` VALUES ('16', '16', 'mdr.gif', ':mdr:');
INSERT INTO `appel_livre_smileys` VALUES ('17', '17', 'cheer.gif', ':-)X');
INSERT INTO `appel_livre_smileys` VALUES ('18', '18', 'acllamer.gif', ':-//');

-- `appel_livre_img_verif_add` DATAS


