-- @lex Guestbook Backup
-- version 5.0.2
-- By Alexis Soulard, Pierre Gieling, Maxime Hercelin (c)
-- http://www.alexguestbook.net
-- Date : 05/01/2011 21:25:39

DROP TABLE IF EXISTS `alex_livre_config`;
DROP TABLE IF EXISTS `alex_livre_txt_lang`;
DROP TABLE IF EXISTS `alex_livre_sessions`;
DROP TABLE IF EXISTS `alex_livre_users`;
DROP TABLE IF EXISTS `alex_livre_messages`;
DROP TABLE IF EXISTS `alex_livre_censure`;
DROP TABLE IF EXISTS `alex_livre_ban`;
DROP TABLE IF EXISTS `alex_livre_smileys`;
DROP TABLE IF EXISTS `alex_livre_img_verif_add`;

CREATE TABLE `alex_livre_censure` (
  `id_mot` mediumint(11) unsigned NOT NULL auto_increment,
  `texte_censure` varchar(255) NOT NULL default '',
  `texte_remplace` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id_mot`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_ban` (
  `id_ban` mediumint(11) unsigned NOT NULL auto_increment,
  `ip` varchar(15) NOT NULL default '',
  `pseudo` VARCHAR(40) NOT NULL default '',
  `email` VARCHAR(150) NOT NULL default '',
  PRIMARY KEY  (`id_ban`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_messages` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `nom` varchar(40) NOT NULL default '',
  `email` varchar(150) NOT NULL default '',
  `site` varchar(150) NOT NULL default '',
  `ville_pays` varchar(60) NOT NULL default '',
  `pays` varchar(2) NOT NULL,
  `note` char(2) default NULL,
  `message` text NOT NULL,
  `titre_reponse` varchar(100) NOT NULL,
  `reponse` text NOT NULL,
  `time` int(11) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `valid` enum('yes','no') NOT NULL default 'yes',
  PRIMARY KEY  (`id`),
  KEY `time` (`time`),
  KEY `valid` (`valid`), 
  KEY `nom` (`nom`), 
  FULLTEXT KEY `message` (`message`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_sessions` (
  `session` varchar(70) NOT NULL default '',
  `id_user` mediumint(11) unsigned NOT NULL default '0',
  `login` varchar(20) NOT NULL default '',
  `last_connect` int(15) NOT NULL default '0',
  KEY `session` (`session`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_smileys` (
  `id_smiley` mediumint(11) unsigned NOT NULL auto_increment,
  `numero` mediumint(8) unsigned NOT NULL default '0',
  `smiley` varchar(255) NOT NULL default '',
  `car_replace` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`id_smiley`),
  KEY `numero` (`numero`)
) TYPE=MyISAM;


CREATE TABLE `alex_livre_users` (
  `id_user` mediumint(11) unsigned NOT NULL auto_increment,
  `login` varchar(20) NOT NULL default '',
  `pass` varchar(10) binary NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `receive_email` tinyint(1) NOT NULL default '0',
  `modif_options` tinyint(1) NOT NULL default '0',
  `gestion_skins` tinyint(1) NOT NULL default '0',
  `gestion_reponse_auto` tinyint(1) NOT NULL default '0',
  `gestion_bdd` tinyint(1) NOT NULL default '0',
  `gestion_messages` tinyint(1) NOT NULL default '0',
  `gestion_censure` tinyint(1) NOT NULL default '0',
  `gestion_bannissement` tinyint(1) NOT NULL default '0',
  `gestion_smileys` tinyint(1) NOT NULL default '0',
  `gestion_admin` tinyint(1) NOT NULL default '0',
  `nb_mess_page` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_user`),
  KEY `login` (`login`),
  KEY `pass` (`pass`)
) TYPE=MyISAM;


CREATE TABLE `alex_livre_img_verif_add` (
  `numero` varchar(10) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `valeur` varchar(5) NOT NULL default '',
  `nom` varchar(40) NOT NULL default '',
  `email` varchar(150) NOT NULL default '',
  `site` varchar(150) NOT NULL default '',
  `ville_pays` varchar(60) NOT NULL default '',
  `pays` varchar(2) NOT NULL,
  `note` char(2) NOT NULL default '',
  `message` text NOT NULL,
  KEY `time` (`time`),
  KEY `numero` (`numero`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_txt_lang` (
 `lang` VARCHAR(20) NOT NULL,
  `type` ENUM('rep_auto', 'titre', 'rep', 'boite'),
  `msg` TEXT NOT NULL,
  INDEX (`lang`) ,
  INDEX (`type`) 
) TYPE=MyISAM;

CREATE TABLE `alex_livre_config` (
  `nom_config` varchar(255) NOT NULL,
  `valeur_config` varchar(255),
  KEY `nom_config` (`nom_config`)
) Type=MyISAM;



-- `alex_livre_config` DATAS

INSERT INTO `alex_livre_config` VALUES ('langue', 'francais');
INSERT INTO `alex_livre_config` VALUES ('skin_to_use', 'AguestNew');
INSERT INTO `alex_livre_config` VALUES ('temps_session', '1800');
INSERT INTO `alex_livre_config` VALUES ('send_mail', '1');
INSERT INTO `alex_livre_config` VALUES ('temps_ip_post', '60');
INSERT INTO `alex_livre_config` VALUES ('format_date', 'd/m/Y');
INSERT INTO `alex_livre_config` VALUES ('admin_valide_messages', '0');
INSERT INTO `alex_livre_config` VALUES ('admin_envoyer_remerciement', '1');
INSERT INTO `alex_livre_config` VALUES ('admin_add_code_securite', '1');
INSERT INTO `alex_livre_config` VALUES ('admin_bannir_mot', '0');
INSERT INTO `alex_livre_config` VALUES ('url_interdites', '1');
INSERT INTO `alex_livre_config` VALUES ('url_cliquables', '0');
INSERT INTO `alex_livre_config` VALUES ('color_txt_code', '#000000');
INSERT INTO `alex_livre_config` VALUES ('color_background_code', '#FFFFFF');
INSERT INTO `alex_livre_config` VALUES ('champ_pseudo', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_email', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_site', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_pays', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_note', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_ville', '0');
INSERT INTO `alex_livre_config` VALUES ('ok_aff_moteur', '1');
INSERT INTO `alex_livre_config` VALUES ('nb_pages', '50');
INSERT INTO `alex_livre_config` VALUES ('cut_mots', '75');
INSERT INTO `alex_livre_config` VALUES ('maxi_car', '1500');
INSERT INTO `alex_livre_config` VALUES ('nb_max_smileys', '20');
INSERT INTO `alex_livre_config` VALUES ('url_recharger', 'index.php');
INSERT INTO `alex_livre_config` VALUES ('extension_url', '');
INSERT INTO `alex_livre_config` VALUES ('decalage_horaire', '0');
INSERT INTO `alex_livre_config` VALUES ('autoriser_smileys', '1');
INSERT INTO `alex_livre_config` VALUES ('inclure_livre', '0');
INSERT INTO `alex_livre_config` VALUES ('fichier_inclusion', '');
INSERT INTO `alex_livre_config` VALUES ('donner_focus', '0');
INSERT INTO `alex_livre_config` VALUES ('lien_admin', '1');
INSERT INTO `alex_livre_config` VALUES ('lien_accueil', '1');
INSERT INTO `alex_livre_config` VALUES ('chemin_lien_accueil', '/');
INSERT INTO `alex_livre_config` VALUES ('symbole_champ_obligatoire', '*');
INSERT INTO `alex_livre_config` VALUES ('symbole_champ_prive', '[P]');

-- `alex_livre_txt_lang` DATAS

INSERT INTO `alex_livre_txt_lang` VALUES ('francais', 'titre', 'Appel pour les Arbres Venerables');
INSERT INTO `alex_livre_txt_lang` VALUES ('english', 'titre', 'Call for Venerable Trees');
INSERT INTO `alex_livre_txt_lang` VALUES ('', 'rep', 'R');

-- `alex_livre_sessions` DATAS

INSERT INTO `alex_livre_sessions` VALUES ('6f7fb113152d1fa46470776a4f5cfd3f', '1', 'arbres-venerables', '1294259139');

-- `alex_livre_users` DATAS

INSERT INTO `alex_livre_users` VALUES ('1', 'arbres-venerables', 'mycena1967', 'arbres-venerables@orange.fr', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '80');

-- `alex_livre_messages` DATAS

INSERT INTO `alex_livre_messages` VALUES ('1', 'Arbresvenerables', 'arbres-venerables@orange.fr', 'http://arbresvenerables.free.fr', 'Terrasson', 'fr', '8', 'Bonjour amis des arbres\r\nBienvenue dans mon nouveau livre d\'or, les anciens messages sont en dessous, n\'ayez crainte ! Ils sont sauvegard', '', '', '1259094374', '82.250.179.83', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('3', 'Thibault', 'grange.thibault@hotmail.fr', '', 'Brive la Gaillarde', 'fr', '10', 'Merci Jrme pour ce site, o sont retracs tant d\'\'instants de voyage, tant d\'\'instants insignifiants dans la vie d\'\'un arbre mais pas dans celle d\'\'un pauvre humain ; Merci pour ce combat dont tout le monde se fout et qui est pourtant primordial, merci pour tout, pour eux, pour nous, pour vous....Si jamais vous tombez sur ce site, sur ce post, et que vous tes intress par le travail de Jrme n\'\'hsitez pas  le contacter, il est trs ouvert et aime partager son travail.Le hasard fait parfois trs bien les choses...merci  toi Jrme', '', '', '1260280138', '89.90.5.71', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('4', 'Christine Desmarais', 'christinedesmarais@live.ca', 'http://www.foliadesign.ca', 'St-Lambert-de-Lauzon', 'ca', '10', 'Bravo pour cette initiative plus que ncessaire, si tu as besoin de contacts par ici j\'\'en ai. Ne lches pas, on a besoin de gars comme toi! Merci d\'\'tre l.', '', '', '1260408514', '66.110.151.35', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('5', 'Woodman0369', 'david.buatois@live.fr', '', 'Saint thois', 'fr', '10', 'merci pour eux  , les arbres sont vivants!!!stop  la taille svere :GG !! en effet je suis\" arboriste grimpeur  passionn\" prservons le patrimoine arbor.   halte aux massacres !!! merci  vous  \r\n:-//          cordalement   eurl gaia paysage elagage    david', '', '', '1261576914', '81.20.208.15', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('6', 'Cario pascal', 'orchidee-973@hotmail.fr', '', 'Kourou', 'gf', '9', 'ca fait plaisir et ca remonte un peu le moral, de trs grand et anciens arbres vivent en guyane mais quels massacres!!les voir tomber par la betisse et la cupidit des humains me fait l\'\'effet d une saign, je suis jardinier et prof d\'\'horticulture,j\'\'ai planter pas mal d\'\'ardres,essayer d\'\'en protgerd \'\'autres, mais les pertes ont t sveres(trs). mais  on doit bien continuer!bonne anne a tous.', 'Bonne Anne 2010', 'Bonjour et bonne anne 2010, anne internationale pour la biodiversit.\r\nVoir ses arbres c\'\'est merveilleux, mais voir d\'\'autres tomber, et sans valorisation de l\'\'arbre, c\'\'est lamentable.\r\nJe ne connais pas encore la Guyane, peut tre un de ces jours...faites moi venir et exposer en Guyane !\r\nJrme', '1262525468', '80.8.233.45', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('7', 'CyranOrion', 'jeannot.lebrun@club-internet.fr', '', 'Le Bouscat', 'fr', '9', 'Bravo et merci.', '', '', '1263107557', '93.1.191.196', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('8', 'Dr Monica Marcu', 'nature@photomarcu.com', 'http://www.photomarcu.com', 'Seattle', 'us', '9', 'We are here on this galactic ship we call Earth because of the trees, they give us breath, water and housing, they are gentle and patient parents.  There will be no life without them, there has never been life without trees. All trees are \"venerable\". We thank you, trees, and embrace you. ', '', '', '1264361396', '98.247.32.167', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('9', 'Julie Morana', '', '', '', 'fr', '9', 'Bravo Jrme pour cette initiative !\r\nMerci.', 'R', 'Merci Julie pour votre message.\r\nComment avez vous connu cet appel? O tes vous?\r\nA bientt,\r\nBonne anne 2010, anne internationale pour la biodiversit.\r\nJrme', '1265117654', '79.84.132.152', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('10', 'BUFFLER', 'hellodelph@hotmail.com', '', 'Paris', 'fr', '9', 'Votre initiative est super et je ne la connaissais pas.\r\nC\'est en faisant une recherche pour mes tudes universitaires sur le Baobab que \'\'ai dcouvert votre livre qui est magnifique et passionnant. \r\nJ\'aime l\'\'arbre sous toutes ses formes, il est si beau \r\nMes plus beaux souvenirs d\'\'enfance sont lis  la nature  l\'arbre, l\'arbre est donc dans mon coeur. Le souci dont vous faite part dans l\'appel pour l\'arbre devrait devenir le soucis de tous les tres humains de la plante, et effectivement il pourrait tre un moyen de rapprochement des civilisations et de pacification car en effet l\'arbre est un lment universel.\r\nDonc, encore merci de porter cette cause  la fois cologique, potique et sacre qu\'est la cause de l\'arbre.\r\nAvec mon plus grand soutient\r\nDelphine BUFFLER', '', '', '1265150811', '83.202.83.71', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('11', 'Joce', 'lynajo5547@neuf.fr', 'http://www.saisons-vives.com', '', 'fr', '9', 'Bravo pour ces magnifiques photos et pour l\'\'action entreprise.\r\nJe rponds  l\'\'Appel pour sauver ces merveilleux arbres !', '', '', '1265630042', '77.201.196.176', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('12', 'Hulin Dominique', 'dominiquehulin@orange.fr', '', 'Neuilly sur marne', 'fr', '10', 'Notre mre terre a bien besoin de l\'\'aide et de l\'\'amour de ses enfants impis.', '', '', '1265794513', '82.121.66.33', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('13', 'Cath Strauss', 'cath.strauss@free.fr', '', 'St Nazaire le Dsert 26', 'fr', '10', 'Arbres vnrables : C\'\'est exactement cela !!!\r\nComment ne pas sentir un profond respect devant ces tres ???\r\nPour info , en Drme provenale  Chastel Arnaud , prcisment , il y a un chtaignier g entre 500 et 700 ans : Une merveille !', '', '', '1266519058', '82.249.245.17', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('14', 'Raphael Loison', 'raphael.loison@culture.gouv.fr', 'http://mandadjinn.free.fr/diaporama/index.html', 'Paris', 'fr', '7', 'C\'est une triste chose de penser que la nature parle et que le genre humain n\'coute pas.  Victor Hugo\r\nIl y a un certain respect qui nous attache, et un gnral devoir d\'humanit, non aux btes seulement qui ont vie et sentiment, mais aux arbres et aux plantes.  Montaigne\r\nL\'arbre a toujours t pour l\'homme un modle et un symbole de sa situation et de son rle sur terre.\r\nEntre optimisme et lucidit, nous pouvons au moins donner nos voix aux arbres muets pour nos oreilles limites mais qui parlent si fortement  nos mes.', '', '', '1268139803', '143.126.201.151', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('15', 'Gael56', 'jongle.56@orange.fr', '', 'Lorient', 'fr', '8', 'Les arbres remarquables, venerables,... sontt de rels richesses du patrimoine naturel (reference historique, geographique,....). En france, il existe quelques lois, protections mais malheureusement rien de solide car on voit encore de nos jours des chenes, tulipier, ...de 2,3,.. siecles se faire abattre pour des raisons de securit (maladies, menace pr les habitaions,...) Qui etait la en premier la maison ou l\'arbre ?  L\'humain a t\'il plus de valeur que ces especes, temoins du pass ?  La solution en france sa serait un perimetre de secu ou chacun est seul responsable \"a vos riques et perils\" en approchant ces etres que ce soit public ou priv. En meme temps priv ne veut rien dire car ils font partie du patrimoine naturels du vivant. Je vs soutiens a 100 % afin d\'\'obtenir un classement les rendant ainsi intouchables.', '', '', '1268246430', '90.25.22.146', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('16', 'Helder', 'helder.perrin@laposte.net', '', 'La Salvetat-sur-Agot (34)', 'fr', '8', 'Trs bonne prise de conscience  initier. Avec toute la gratitude du travail avec les arbres remarquables du Haut-Languedoc,\r\nHelder', '', '', '1269608746', '82.127.81.193', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('17', 'Tom Bombadil', 'perenialisme@hotmail.fr', '', 'Genve', 'ch', '10', 'Bonjour,\r\nMerci infiniment pour la qualit de votre site que je viens de dcouvrir aprs une recherche sur Internet relativement aux arbres les plus vieux. \r\n\r\nEn me promenant sur votre site je songe  deux crivains amis qui sont chers  mon coeur et qui furent tous deux en trs forte empathie avec les arbres : le Pr de linguistique et crivain J.R.R. Tolkien et le thologien et crivain C.S. Lewis. Une anecdote rvlatrice de l\'attitude de Tolkien  ce propos : la seule fois de son existence o il manifesta publiquement ses opinions \"politiques\" concerne un arbre  ct de l\'\'Universit d\'\'Oxford qui devait tre dplac ou abattu et Tolkien s\'est fait photographier  ses cts avant ! \r\nIl convient de se souvenir galement de l\'importance de Silvebarbe et de son immmoriale conscience \"arbresque\" dans l\'\'exceptionnel \"Seigneur des Anneaux\", qui a reprsent pour l\'crivain prs de quatorze annes de labeur, en plus de la prparation de ses cours  l\'Universit et de sa vie de famille !... \r\n\r\nIl faut que je parvienne  dcouvrir un exemplaire de votre livre puis car il suscite toute ma chaleureuse attention !...\r\nEncore toutes mes flicitations pour votre travail et mes plus cordiales penses (\"arbresques\") !...\r\n\r\nTom Bombadil de Suisse', '', '', '1269649124', '62.167.36.167', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('18', 'RICHARD PREIRA', 'richardpreira@gmail.com', '', 'Vendome(41)', 'fr', '10', 'Bonjour,M.Hutin \r\nje suis moi mme ts proche et sensible  ces merveilleux vgtaux.En tant qu\'Arboriste grimpeur j ai un rapport trs privlgi avec les arbres auxquels je voue un grand respect.Cela fait plus de 10ans que je me bat auprs de mes clients et du grand public pour les sensibiliser aux bonnes pratiques de l\'lagage en collaboration avec la Socite Franaise d Arboriculture dont je suis adhrant depuis de nombreuses annes.Votre site est trs bien fait cela fait plaisir d\'tre en contact avec des gens pationns un grand merci  vous et aux arbres  bientot  Richard P (Etps Aux Arbres Etcaetera)', '', '', '1269665139', '93.13.33.171', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('19', 'Guyon', 'guyonfamily@aol.com', 'http://biodiversite21.fr', 'Maurepas', 'fr', '10', 'Les arbres c\'est la vie !', '', '', '1269713652', '86.70.202.25', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('20', 'Cline', 'pitzappatta@hotmail.fr', '', 'Drome', 'fr', '10', 'Je me joins  tous!\r\nCe n\'est que quand il aura fait tomber le dernier arbre, contamin le dernier ruisseau, pch le dernier poisson, que l\'homme s\'apercevra que l\'argent n\'est pas comestible.', '', '', '1269729347', '92.157.56.45', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('21', 'Rubin', 'caroletter@hotmail.fr', '', '', 'fr', '10', 'respect et longue vie au vivant, les arbres sont l\'oxygne de cette plante, protgeons-les !', '', '', '1270462871', '82.64.7.238', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('22', 'Tison Christophe', 'hj.tison@laposte.net', '', 'Fontaine (38)', 'fr', '9', 'Pour nos racines  tous !...\r\nContinuez !\r\nChristophe', '', '', '1271269651', '86.206.11.186', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('23', 'Mo', 'momartinet@wanadoo.fr', '', 'Siorac en prigord', 'fr', '9', 'une petite pense pour nos amis les arbres \r\nhier nous en avons plant encore \r\nqu\'\'ils grandissent en paix!...', '', '', '1274120796', '92.134.138.45', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('24', 'Daniel Bellerose', '', '', 'Montral', 'ca', '10', 'Quelle belle initiative que cet Appel des Arbres vnrables. Bravo!', '', '', '1275491653', '70.54.227.50', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('25', 'Lecomte', 'agnes.lecomte@sfr.fr', '', 'Epernay', 'fr', '10', 'En soutien  mes amis les arbres, qui me donnent tant d\'\'nergie !', '', '', '1275663608', '84.100.73.123', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('26', 'Syl20', 'mr.syl20@gmail.com', '', 'Joyeuse', 'fr', '5', 'Merci pour cette initiative  :-)X  ', '', '', '1275671046', '90.53.235.91', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('27', 'Juliette Roux', 'eomunia@gmail.com', '', 'La chapelle des marais', 'fr', '10', 'Oui, 100% pour', '', '', '1275672143', '82.249.201.135', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('28', 'Stphanie muzard le moing', 'atelierdesmuses@wanadoo.fr', 'http://www.sansterresetsansreproches.fr', 'Marcilhac-sur-cl', 'fr', '10', 'interdire les plantations d\'arbres OGM... :V) ', '', '', '1275673012', '90.5.42.58', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('29', 'Haouchine', 'predineka@yahoo.fr', '', 'Paris', 'fr', '10', 'yes', '', '', '1275673089', '78.250.231.207', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('30', 'SIFOUANE', 'tilak2tilak@hotmail.com', '', 'RUEIL MALMAISON', 'fr', '10', 'evidemment !!!! adhre et signe !!', '', '', '1275676171', '92.154.70.47', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('31', 'Audrey', 'audrey131185@hotmail.fr', '', 'Nice', 'fr', '10', 'yes', '', '', '1275676374', '85.170.239.231', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('32', 'S', 'mlle-sevy73@hotmail.fr', '', 'St pryv st mesmin', 'fr', '7', 'yes', '', '', '1275676518', '88.219.230.171', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('33', 'Omnes', 'stephanieomnes@yahoo.fr', '', 'Viller', 'fr', '10', 'Il apparat comme tout  fait vident que ces arbres vnrables soient classs au Patrimoine Mondial. Je vois mal quelle raisons pourraient tre voques pour refuser cette requte. Ils sont aussi notre mmoire, un lien vivant avec le pass !', '', '', '1275676747', '77.193.6.18', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('34', 'Ly', 'leslilas.ly@gmail.com', '', 'Marches', 'fr', '10', ' :-// ', '', '', '1275677839', '90.53.75.196', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('35', 'Mchl', 'michelegentilini@orange.fr', '', 'Saultain', 'fr', '9', 'Appel pour le classement des Arbres Vnrables de la Planete, au Patrimoine mondial', '', '', '1275679927', '86.215.129.137', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('36', 'MATICHARD', 'pascale.matichard@free.fr', '', 'Les Assions', 'fr', '10', 'parcequ\'ils le valent bien!!!', '', '', '1275686986', '82.249.149.21', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('37', 'Roinet', 'thierry.roinet@neuf.fr', '', 'Marseille', 'fr', '8', 'Il semble logique de prserver ce qui reste de notre Nature.', '', '', '1275687060', '79.84.110.237', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('38', 'Francine demuynck', 'francine_d42@yahoo.fr', '', 'Bruxelles', 'be', '10', 'http://arbres-inventaire.irisnet.be/arbre/Elsene_Oude-Lindesquare/1290/\r\ncelui-ci c\'\'est le mien, celui de mon enfance quand en sortant de l\'cole on venait boire l\'eau de la fontaine, tout comme Charles Quint l\'avait fait lors de son passage dans mon beau hameau de Boendael.\r\nJ\'en appelle  la sagesse, ne l\'\'abattez pas.', '', '', '1275687949', '81.242.225.2', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('39', 'Franoise nalet', 'francoise.nalet@yahoo.fr', '', 'Saint paul les dax', 'fr', '9', ' :V)  bonheur de dcouvrir ce site, trs complet, pas fini de l\'explorer, en tous cas bravo pour la cause des grands et beaux et majestueux arbres qu\'il faut dfendre protger et faire connatre. merci pour tout a .. ', '', '', '1275688577', '90.45.171.4', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('40', 'CLEMENT', 'clt.a@orange.fr', '', 'Errouville', 'fr', '10', 'Les arbres tres anciens mritent le respect que l\'on doit donner aux vieux sages qui ont travers le temps. Mais dans le monde, parfois, nous les oublions dans un bout de foret, une tendue de dsert, une pente de montagne. Pire encore on les abat parfois, sans sommation.', '', '', '1275689656', '90.33.50.183', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('41', 'France Mosconi', 'francemosconi@gmail.com', '', 'Cuernavaca, Morelos', 'mx', '8', '\"... Je suis revenu dans la fort. Entre la  porte  des deux arbres, jobserve le matre de ce lieu : mon arbre. Je nai pu rsister  trois jours de sparation et cette fois, cest sous les rayons dune fin daprs-midi ensoleille que je le contemple.\r\n\r\nJe nose lapprocher, tant il mimpressionne. De plus, ce quelque chose dindfinissable qui mane de lui me prend entirement. Jai parfois limpression quune force immense sest tablie  cet endroit pour prendre une forme majestueuse darbre.\r\n\r\nLes rayons dun soleil dclinant vernissent dun or tremblant les bords des feuillages. Lair est stri de chants doiseaux. En contrebas sur le chemin sattardent encore deux promeneurs.\r\n\r\nJe me dcide pourtant. Franchissant la porte vgtale, je fais quelques pas dans la clairire, puis je marrte. Je rejoins larbre et aprs lavoir caress je massois contre lui, me cale entre ses racines. Ainsi arrim, je peux reprendre mon rve et mimprgner du chant des oiseaux. Et tous ces chants sont comme un sang de vie, nourriture sonore des arbres qui semblent les couter de toute leur puissance concentre.\r\n\r\nJe ferme les yeux pour mieux men pntrer. Chaque trille, chaque roulade. met comme dinvisibles cellules de vie dans lespace et va amplifier le gigantesque corps spirituel de la nature.\r\n\r\nJe me prends  envier limmobilit de mon arbre - immobilit dailleurs apparente. Jimagine que cela fait trs longtemps que je suis l, me confrontant comme lui au pouvoir des saisons et les intgrant dans ma sve.\r\n\r\nCest cette immobilit qui fait ma force, car elle me permet de transformer la lumire en cellules et de boire les sucs de la terre ; par mes feuilles, je peux valuer la sensibilit du plus tnu souffle de vent.\r\n\r\nPuis je redeviens homme, car ma fonction est telle. Il me revient alors en mmoire ce que disait Yannis. mon fils, lorsquil avait cinq ans,  propos des arbres :  Les arbres rient quand ils sont contents.  Comme on lui fit remarquer, un peu pour en savoir plus, que les arbres navaient pas de bouche pour rire, Yannis se mit  rflchir quelques secondes avant dajouter :  Mais ils rient avec leurs feuilles. \r\n\r\nEt comme pour souligner ce souvenir, larbre se met  rire de toutes ses feuilles. Cest sa faon  lui de diffuser, grce  la complicit du vent, sa joie de vivre. Bientt tous les arbres de la clairire frissonnent de rire.\r\n\r\nUne feuille tombe et me touche le front. Je la prends crmonieusement et la mets dans ma poche en gage damiti de mon arbre.\"\r\n\r\nMario Mercier, \"L\'\'enseignement de l\'\'arbre matre\"', '', '', '1275690580', '189.221.1.220', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('42', 'Bruno MotaAlemLopesDaBenta', 'LeCamionVegetarien@hotmail.fr', 'http://www.LeCamionVegetarien.com', 'Marmande', 'fr', '10', 'nous  marmande contactons-nous des qu\'un evenement est organis nous relayerons avec plaisir et viendrons vous y faire a manger\r\nau plaisir et  bientot', '', '', '1275690668', '77.206.56.189', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('43', '', '', '', 'Clermont ferrand', 'fr', '9', 'Quoi de plus naturel que d\'essayer de conserver ces beaux arbres', '', '', '1275691740', '86.194.140.179', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('44', 'Debbeche', 'debb113@hotmail.com', '', '', 'fr', '6', 'respect three ', '', '', '1275701519', '81.220.237.222', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('45', 'BETRENCOURT', 'nicole.betrencourt@wanadoo.fr', '', 'Neuilly sur Seine', 'fr', '9', 'Oui il me parat important de sauver la nature sous toutes ses formes.', '', '', '1275722117', '82.124.184.231', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('46', 'Francoise.lafitte', 'francoise.laffite@wanadoo.fr', '', 'Volgre', 'fr', '9', ' bravo!:-)X ', '', '', '1275725179', '90.39.72.207', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('47', 'Sonia Fey', 'sfey@pointvert.com', '', 'Deroche', 'ca', '8', 'Nous nous devons de proteger les abres dans le monde entier. Stop a la deforestation - et conservons les arbres venerables...... ', '', '', '1275829591', '65.38.43.158', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('48', 'Edith Smeesters', 'edithsmeesters@hughes.net', '', 'Potton', 'ca', '10', 'Bravo pour cette initiative!', '', '', '1275830484', '69.19.14.31', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('49', 'Cylab', 'cl5571@aol.com', '', 'Paris', 'fr', '8', 'Une noble cause mrite le soutien .\r\nMerci  vous.', '', '', '1275893110', '82.230.150.44', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('50', 'Carlo', 'sylvicarlo@yahoo.fr', '', '', 'fr', '10', 'bravo pour cette initiative, la nature est sacre....', '', '', '1275936013', '86.210.173.72', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('51', 'REDA', 'reda1916@live.fr', '', 'Nantes', 'fr', '10', 'QUE DIRE ?JE PENSE QUE DEVANT UN ARBRE PAREIL ON ARRETTE DE PARLER ET ON FAIT PLACE A NOTRE ETRE POUR ETRE EN COMUNION EN LIEN OU JE NE SAIS MERC\r\nI ENCORE SYLVAIN', '', '', '1276075318', '82.236.186.245', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('52', 'Berhault-Creuzet', 'cryingveins@yahoo.fr', 'http://coralieberhault.over-blog.com', 'Thiers', 'fr', '10', 'Une ide trs belle et... naturelle', '', '', '1276260483', '77.197.58.121', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('53', 'Flore', 'nothing1914@ahoo.fr', '', 'Arconsat', 'fr', '10', 'Une petite contribution pour une noble cause. Ces arbres millnaires sont nos anctres autant que peuvent l\'tre nos grand-pre, arrire grand-mre... Nous leurs devons la vie.', '', '', '1276705604', '77.197.23.12', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('54', 'Florange', 'chambon.flo@gmail.com', 'http://www.clenature.fr', 'LEMPDES', 'fr', '10', 'Oui, les arbres mritent le plus grand respect, pas seulement ceux qui sont remarquables... Mais si au moins ceux l pouvaient rendre aux Hommes un peu de leur humilit...', '', '', '1277129965', '86.194.139.22', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('55', 'Krillis Hlne', 'hkerillis@gmail.com', 'http://cocax.free.fr', 'Bordeaux', 'fr', '9', 'Le jour pour inspirer, la nuit pour expirer, c\'est la lente respiration des arbres vnrables,  la mesure de leur majest.', '', '', '1277187008', '77.200.162.207', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('56', 'Marie Michle', 'marie.michele26@orange.fr', '', 'Mont', 'fr', '10', 'Bravo pour votre initiative.\r\nJ\'adhre  votre ide  100/100.', '', '', '1279218600', '86.194.245.10', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('57', 'Emmanuel Pluchon', 'epeluchon@videotron.ca', 'http://www.emmanuelpeluchon.com', '', 'ca', '10', 'Ces arbres vnrables sont les gardiens de notre Humanit, russir  obtenir leur protection serait la preuve que l\'\'Homme a encore une conscience.\r\n\r\nBravo pour ton oeuvre et ce magnifique livre qui mriterait d\'\'tre rdit!', '', '', '1279899652', '66.131.244.112', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('58', 'Coline', 'coline05@msn.com', '', 'Vende', 'fr', '10', 'Ils sont notre oxygne protgeons les.', '', '', '1281425908', '90.12.142.30', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('59', 'Manon Letarte', 'mletarte@lafeuilleverte.ca', 'http://www.lafeuilleverte.ca', 'Bromont', 'ca', '10', 'Bonne continuit !', '', '', '1281440063', '66.131.231.242', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('60', 'Mauriange', 'mariejosemauriange@yahoo.ca', '', 'Cowansville', 'ca', '10', 'Sauvez les arbres c\'est sauvez une partie de la vie de la plante :-D  :-D  :-D  :-D ', '', '', '1281446381', '67.71.132.174', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('61', 'Ursault dominique', 'dominiqueursault@orange.fr', '', 'Girouard', 'fr', '9', 'bonne chance pour eux', '', '', '1281469823', '90.12.142.30', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('62', 'Cunaigonde', 'stephanie.bousselaire@laposte.fr', '', 'Evreux', 'fr', '10', 'Merci de penser  nos enfants merci de penser  notre naturel si belle si forte mais si fragile !!!!!', '', '', '1281513459', '80.118.33.228', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('63', 'Dorey Valrie', 'valdorey@gmail.Com', '', 'St Magne', 'fr', '9', 'Je m\'associe  votre action pour protger les arbres de notre Terre Mre, ces arbres sans qui notre souffle s\'\'teindrait, ces tres merveilleux qui nous offrent leur ombre, leur abri, leurs fruits et le chant de leurs frondaisons sous le vent qui chuchote  nos oreilles l\'histoire de l\'humanit sur cette plante qui nous supporte. Quand un arbre meurt, c\'est un peu de mon me qui meurt. \r\n\r\nValrie', '', '', '1281522491', '90.60.248.77', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('64', 'PARIENTE', 'parientelisabeth@gmail.com', 'http://arcnaelle.unblog.fr/', 'GUJAN MESTRAS', 'fr', '10', 'Merci pour ce magnifique tmoignage de notre reliance  l\'univers. Ces arbres contiennent en eux tellement de beaut.\r\n\r\nBonne continuation\r\n\r\nEP', '', '', '1281523741', '78.122.94.208', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('65', 'Caillou', 'danielle.bertounesque@wanadoo.fr', '', 'Nergiean', 'fr', '10', 'vous tuez notre mre, la Terre ? :cry:', '', '', '1281598515', '82.125.106.41', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('66', 'Annie Loiseau', 'annieloiseau@hotmail.com', '', 'Ste-Brigitte-de-laval', 'ca', '8', 'J\'appuie toutes actions visant la protection de nos arbres!\r\nVivement une plante saine et arborescente!!!', '', '', '1281965136', '70.25.42.211', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('67', 'Calendula', 'lulu.calendula@orange.fr', '', 'Saint urcize', 'fr', '10', 'arbres vnrables: vestiges du pass.... gardiens de nos souvenirs.... de la terre vers le ciel....', '', '', '1282084201', '90.10.202.158', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('68', 'Lumina', 'vivi.maxence@hotmail.fr', '', '', 'fr', '', 'Je ne vous connais pas, mais vous tes quelq\'un d\'\'incroyable.\r\nJ\'aurais du trouver ce site plus tt!\r\nQuel courage!\r\nUn grand merci.', '', '', '1283874873', '92.142.250.80', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('69', 'Victoria', 'vivi.maxence@hotmail.fr', '', '', 'fr', '10', 'Toujours moi! Je dis: respect!\r\n\r\nJe croyais tre la seule  aimer les arbres  ce point!\r\n\r\nJe trouve quelques personnes de mon entourage presque sarcastique...\r\n\r\nJe suis heureuse d\'apprendre que je ne suis pas la seule.\r\n\r\nA voir les photos j\'en pleurais presque.\r\n\r\nContinuez, vraiment!', '', '', '1283875180', '92.142.250.80', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('70', 'Deborah matthiesen', '', '', '', 'br', '10', 'It is such an important work that you are doing to protect and call the world to take care of the Venerable Trees of the Earth!\r\n\r\nI will help to divulge it and hope that someday we can have you & your pictures here in Brasil!!\r\n\r\nWhat the world needs is people like you, that believe and make it happen!!!', '', '', '1285789276', '201.52.150.48', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('71', 'Sandralili', 'sandralili@msn.com', '', '11350', 'fr', '8', ' :V)  :-)X  :-//  :V) ', '', '', '1285889747', '86.197.175.224', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('72', 'Believe', 'belle1eve@gmail.com', '', 'Genve', 'ch', '10', 'Merci pour ce beau travail. :-)X \r\n\r\nQue la nature fleurisse de manire luxuriante et harmonieuse.', '', '', '1286969182', '193.138.73.1', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('73', 'Chris ', 'chrisreinette.67@gmail.com', '', 'Brumath', 'fr', '7', 'Ces arbres sont nos anctres - il faut les prsever de la hargne, du besoin de destruction de l\'homme - sauvons les ....', '', '', '1288792148', '88.164.164.63', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('74', 'Hector de Ternant', '', '', '', 'fr', '9', 'Larbre est un modle de diversit par ses nombreuses espces, il est apaisant, beau, essentiel  la vie par ce quil produit, protecteur,. Compagnon silencieux, il inspire la sagesse. Il est toujours respectable avant dtre vnrable.\r\n\r\nClasser les plus anciens d\'entre eux au Patrimoine Mondial est la moindre reconnaissance quon leur doit !', '', '', '1289065572', '82.232.15.19', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('75', 'Gny-Kergoat  Marc\'\'h\'', 'march.geny-kergoat@laposte.net', '', 'Boulbon', 'fr', '9', 'L\'arbre est un frre, comme nous il puise sa force dans l\'enracinement, tire sa tte au ciel des ides pour humer l\'absolu, tend ses bras pour serrer contre son coeur tous ceux qui viennent  sa rencontre. Oublier l\'arbre c\'est trancher le lien qui nous relie  la nature et errer dans un dsert d\'artifices et de dsillusions. Les vnrables veillent sur nous, sur cette longue file d\'humains qu\'ils ont vu dfiler,  notre tour de veiller sur eux...\'', '', '', '1289824603', '194.199.224.161', 'yes');
INSERT INTO `alex_livre_messages` VALUES ('76', 'Vincent cactus', 'vins.ouille@live.fr', '', 'Lavaur tarn ', 'fr', '10', ' :-)X merci pour eux et aussi pour nous tous , j\'espre que beaucoup de gens se rendent compte de l\'importance du regne vgtal.\r\n', '', '', '1289885247', '93.28.71.91', 'yes');

-- `alex_livre_censure` DATAS


-- `alex_livre_ban` DATAS


-- `alex_livre_smileys` DATAS

INSERT INTO `alex_livre_smileys` VALUES ('1', '1', 'smile.gif', ':)');
INSERT INTO `alex_livre_smileys` VALUES ('2', '2', 'biggrin.gif', ':-D');
INSERT INTO `alex_livre_smileys` VALUES ('3', '3', 'confused.gif', ':?');
INSERT INTO `alex_livre_smileys` VALUES ('4', '4', 'cool.gif', '8)');
INSERT INTO `alex_livre_smileys` VALUES ('5', '5', 'cry.gif', ':cry:');
INSERT INTO `alex_livre_smileys` VALUES ('6', '6', 'eek.gif', ':shock:');
INSERT INTO `alex_livre_smileys` VALUES ('7', '7', 'love.gif', ':V)');
INSERT INTO `alex_livre_smileys` VALUES ('8', '8', 'mad.gif', ':x');
INSERT INTO `alex_livre_smileys` VALUES ('9', '9', 'lol.gif', ':lol:');
INSERT INTO `alex_livre_smileys` VALUES ('10', '10', 'surprised.gif', '8-O');
INSERT INTO `alex_livre_smileys` VALUES ('11', '11', 'wink.gif', ':;');
INSERT INTO `alex_livre_smileys` VALUES ('12', '12', 'ooops.gif', ':oops:');
INSERT INTO `alex_livre_smileys` VALUES ('13', '13', 'twisted.gif', ':twisted:');
INSERT INTO `alex_livre_smileys` VALUES ('14', '14', 'evil.gif', ':evil:');
INSERT INTO `alex_livre_smileys` VALUES ('15', '15', 'furious.gif', ':GG');
INSERT INTO `alex_livre_smileys` VALUES ('16', '16', 'mdr.gif', ':mdr:');
INSERT INTO `alex_livre_smileys` VALUES ('17', '17', 'cheer.gif', ':-)X');
INSERT INTO `alex_livre_smileys` VALUES ('18', '18', 'acllamer.gif', ':-//');

-- `alex_livre_img_verif_add` DATAS

INSERT INTO `alex_livre_img_verif_add` VALUES ('h16V8WBeN8', '1294248517', '', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('NJiC9jTk0R', '1294249139', '', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('rwdZs2C98e', '1294249191', '', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('VRnrAUjLWP', '1294250504', 'WWWB', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('7lzqx4fplj', '1294250606', 'MUYK', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('nMxVJI4mu4', '1294250619', 'GFCW', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('VdmFuht5EO', '1294250868', 'FDED', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('f5vD0riKGd', '1294252992', 'CRGM', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('OsxcYsWWbA', '1294255937', 'HAKK', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('Cth3zJ2H75', '1294255980', 'TSDE', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('5zqztzgd6f', '1294256218', 'GTKE', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('L4gVfEkFqQ', '1294257056', 'SXWH', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('V1pTL7TzEK', '1294257963', 'VQFU', '', '', '', '', '', '', '');

