-- @lex Guestbook Backup
-- version 5.0.2
-- By Alexis Soulard, Pierre Gieling, Maxime Hercelin (c)
-- http://www.alexguestbook.net
-- Date : 05/01/2011 15:03:18

DROP TABLE IF EXISTS `alex_livre_config`;
DROP TABLE IF EXISTS `alex_livre_txt_lang`;
DROP TABLE IF EXISTS `alex_livre_sessions`;
DROP TABLE IF EXISTS `alex_livre_users`;
DROP TABLE IF EXISTS `alex_livre_messages`;
DROP TABLE IF EXISTS `alex_livre_censure`;
DROP TABLE IF EXISTS `alex_livre_ban`;
DROP TABLE IF EXISTS `alex_livre_smileys`;
DROP TABLE IF EXISTS `alex_livre_img_verif_add`;

CREATE TABLE `alex_livre_censure` (
  `id_mot` mediumint(11) unsigned NOT NULL auto_increment,
  `texte_censure` varchar(255) NOT NULL default '',
  `texte_remplace` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id_mot`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_ban` (
  `id_ban` mediumint(11) unsigned NOT NULL auto_increment,
  `ip` varchar(15) NOT NULL default '',
  `pseudo` VARCHAR(40) NOT NULL default '',
  `email` VARCHAR(150) NOT NULL default '',
  PRIMARY KEY  (`id_ban`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_messages` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `nom` varchar(40) NOT NULL default '',
  `email` varchar(150) NOT NULL default '',
  `site` varchar(150) NOT NULL default '',
  `ville_pays` varchar(60) NOT NULL default '',
  `pays` varchar(2) NOT NULL,
  `note` char(2) default NULL,
  `message` text NOT NULL,
  `titre_reponse` varchar(100) NOT NULL,
  `reponse` text NOT NULL,
  `time` int(11) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `valid` enum('yes','no') NOT NULL default 'yes',
  PRIMARY KEY  (`id`),
  KEY `time` (`time`),
  KEY `valid` (`valid`), 
  KEY `nom` (`nom`), 
  FULLTEXT KEY `message` (`message`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_sessions` (
  `session` varchar(70) NOT NULL default '',
  `id_user` mediumint(11) unsigned NOT NULL default '0',
  `login` varchar(20) NOT NULL default '',
  `last_connect` int(15) NOT NULL default '0',
  KEY `session` (`session`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_smileys` (
  `id_smiley` mediumint(11) unsigned NOT NULL auto_increment,
  `numero` mediumint(8) unsigned NOT NULL default '0',
  `smiley` varchar(255) NOT NULL default '',
  `car_replace` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`id_smiley`),
  KEY `numero` (`numero`)
) TYPE=MyISAM;


CREATE TABLE `alex_livre_users` (
  `id_user` mediumint(11) unsigned NOT NULL auto_increment,
  `login` varchar(20) NOT NULL default '',
  `pass` varchar(10) binary NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `receive_email` tinyint(1) NOT NULL default '0',
  `modif_options` tinyint(1) NOT NULL default '0',
  `gestion_skins` tinyint(1) NOT NULL default '0',
  `gestion_reponse_auto` tinyint(1) NOT NULL default '0',
  `gestion_bdd` tinyint(1) NOT NULL default '0',
  `gestion_messages` tinyint(1) NOT NULL default '0',
  `gestion_censure` tinyint(1) NOT NULL default '0',
  `gestion_bannissement` tinyint(1) NOT NULL default '0',
  `gestion_smileys` tinyint(1) NOT NULL default '0',
  `gestion_admin` tinyint(1) NOT NULL default '0',
  `nb_mess_page` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_user`),
  KEY `login` (`login`),
  KEY `pass` (`pass`)
) TYPE=MyISAM;


CREATE TABLE `alex_livre_img_verif_add` (
  `numero` varchar(10) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `valeur` varchar(5) NOT NULL default '',
  `nom` varchar(40) NOT NULL default '',
  `email` varchar(150) NOT NULL default '',
  `site` varchar(150) NOT NULL default '',
  `ville_pays` varchar(60) NOT NULL default '',
  `pays` varchar(2) NOT NULL,
  `note` char(2) NOT NULL default '',
  `message` text NOT NULL,
  KEY `time` (`time`),
  KEY `numero` (`numero`)
) TYPE=MyISAM;

CREATE TABLE `alex_livre_txt_lang` (
 `lang` VARCHAR(20) NOT NULL,
  `type` ENUM('rep_auto', 'titre', 'rep', 'boite'),
  `msg` TEXT NOT NULL,
  INDEX (`lang`) ,
  INDEX (`type`) 
) TYPE=MyISAM;

CREATE TABLE `alex_livre_config` (
  `nom_config` varchar(255) NOT NULL,
  `valeur_config` varchar(255),
  KEY `nom_config` (`nom_config`)
) Type=MyISAM;



-- `alex_livre_config` DATAS

INSERT INTO `alex_livre_config` VALUES ('langue', 'francais');
INSERT INTO `alex_livre_config` VALUES ('skin_to_use', 'AguestNew');
INSERT INTO `alex_livre_config` VALUES ('temps_session', '1800');
INSERT INTO `alex_livre_config` VALUES ('send_mail', '1');
INSERT INTO `alex_livre_config` VALUES ('temps_ip_post', '60');
INSERT INTO `alex_livre_config` VALUES ('format_date', 'd/m/Y');
INSERT INTO `alex_livre_config` VALUES ('admin_valide_messages', '0');
INSERT INTO `alex_livre_config` VALUES ('admin_envoyer_remerciement', '1');
INSERT INTO `alex_livre_config` VALUES ('admin_add_code_securite', '1');
INSERT INTO `alex_livre_config` VALUES ('admin_bannir_mot', '0');
INSERT INTO `alex_livre_config` VALUES ('url_interdites', '1');
INSERT INTO `alex_livre_config` VALUES ('url_cliquables', '0');
INSERT INTO `alex_livre_config` VALUES ('color_txt_code', '#000000');
INSERT INTO `alex_livre_config` VALUES ('color_background_code', '#FFFFFF');
INSERT INTO `alex_livre_config` VALUES ('champ_pseudo', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_email', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_site', '4');
INSERT INTO `alex_livre_config` VALUES ('champ_pays', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_note', '0');
INSERT INTO `alex_livre_config` VALUES ('champ_ville', '0');
INSERT INTO `alex_livre_config` VALUES ('ok_aff_moteur', '0');
INSERT INTO `alex_livre_config` VALUES ('nb_pages', '50');
INSERT INTO `alex_livre_config` VALUES ('cut_mots', '75');
INSERT INTO `alex_livre_config` VALUES ('maxi_car', '1500');
INSERT INTO `alex_livre_config` VALUES ('nb_max_smileys', '20');
INSERT INTO `alex_livre_config` VALUES ('url_recharger', 'index.php');
INSERT INTO `alex_livre_config` VALUES ('extension_url', '');
INSERT INTO `alex_livre_config` VALUES ('decalage_horaire', '0');
INSERT INTO `alex_livre_config` VALUES ('autoriser_smileys', '1');
INSERT INTO `alex_livre_config` VALUES ('inclure_livre', '0');
INSERT INTO `alex_livre_config` VALUES ('fichier_inclusion', '');
INSERT INTO `alex_livre_config` VALUES ('donner_focus', '0');
INSERT INTO `alex_livre_config` VALUES ('lien_admin', '1');
INSERT INTO `alex_livre_config` VALUES ('lien_accueil', '1');
INSERT INTO `alex_livre_config` VALUES ('chemin_lien_accueil', '/');
INSERT INTO `alex_livre_config` VALUES ('symbole_champ_obligatoire', '*');
INSERT INTO `alex_livre_config` VALUES ('symbole_champ_prive', '[P]');

-- `alex_livre_txt_lang` DATAS

INSERT INTO `alex_livre_txt_lang` VALUES ('francais', 'titre', 'Appel pour les Arbres Venerables / Call for Venerable Trees');
INSERT INTO `alex_livre_txt_lang` VALUES ('english', 'titre', 'Call for Venerable Trees');

-- `alex_livre_sessions` DATAS

INSERT INTO `alex_livre_sessions` VALUES ('f5fab5fefa78fd93dd1e563a512ab4c9', '1', 'arbres-venerables', '1294236198');

-- `alex_livre_users` DATAS

INSERT INTO `alex_livre_users` VALUES ('1', 'arbres-venerables', 'mycena1967', 'arbres-venerables@orange.fr', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '15');

-- `alex_livre_messages` DATAS

INSERT INTO `alex_livre_messages` VALUES ('1', 'Arbres-venerables', 'arbres-venerables@orange.fr', 'http://arbresvenerables.free.fr', 'Terrasson-Lavilledieu', 'fr', '10', 'Bonjour et Bonne Anne 2011.\r\nNous clbrons depuis le 1er Janvier 2011 l\'anne internationale de la Fort.\r\nN\'hsitez pas  laisser vos penses arbores sur ce site.\r\nA bientt\r\nJrme Hutin\r\nAdministrateur du site\r\n\r\n----\r\nHello and Happy New Year 2011.\r\nWe celebrate since January 1st, 2011 the international year of the Forest.\r\nDo not hesitate to leave your thoughts raised on this site.\r\nGoodbye\r\nJrme Hutin\r\nAdministrator of the site\r\n\r\n\r\n', '', '', '1294233829', '90.14.21.64', 'yes');

-- `alex_livre_censure` DATAS


-- `alex_livre_ban` DATAS


-- `alex_livre_smileys` DATAS

INSERT INTO `alex_livre_smileys` VALUES ('1', '1', 'smile.gif', ':)');
INSERT INTO `alex_livre_smileys` VALUES ('2', '2', 'biggrin.gif', ':-D');
INSERT INTO `alex_livre_smileys` VALUES ('3', '3', 'confused.gif', ':?');
INSERT INTO `alex_livre_smileys` VALUES ('4', '4', 'cool.gif', '8)');
INSERT INTO `alex_livre_smileys` VALUES ('5', '5', 'cry.gif', ':cry:');
INSERT INTO `alex_livre_smileys` VALUES ('6', '6', 'eek.gif', ':shock:');
INSERT INTO `alex_livre_smileys` VALUES ('7', '7', 'love.gif', ':V)');
INSERT INTO `alex_livre_smileys` VALUES ('8', '8', 'mad.gif', ':x');
INSERT INTO `alex_livre_smileys` VALUES ('9', '9', 'lol.gif', ':lol:');
INSERT INTO `alex_livre_smileys` VALUES ('10', '10', 'surprised.gif', '8-O');
INSERT INTO `alex_livre_smileys` VALUES ('11', '11', 'wink.gif', ':;');
INSERT INTO `alex_livre_smileys` VALUES ('12', '12', 'ooops.gif', ':oops:');
INSERT INTO `alex_livre_smileys` VALUES ('13', '13', 'twisted.gif', ':twisted:');
INSERT INTO `alex_livre_smileys` VALUES ('14', '14', 'evil.gif', ':evil:');
INSERT INTO `alex_livre_smileys` VALUES ('15', '15', 'furious.gif', ':GG');
INSERT INTO `alex_livre_smileys` VALUES ('16', '16', 'mdr.gif', ':mdr:');
INSERT INTO `alex_livre_smileys` VALUES ('17', '17', 'cheer.gif', ':-)X');
INSERT INTO `alex_livre_smileys` VALUES ('18', '18', 'acllamer.gif', ':-//');

-- `alex_livre_img_verif_add` DATAS

INSERT INTO `alex_livre_img_verif_add` VALUES ('l0VszaS2yX', '1294231522', '', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('7ISoRUQtSP', '1294231684', '', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('b6vAKBhaZ6', '1294231734', '', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('9upzeGjrVP', '1294231748', '', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('xNacgOUD7Z', '1294233619', 'WZDN', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('Fesj1okIUA', '1294233831', 'BWMF', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('ponlY5OD6y', '1294234333', 'JVAF', '', '', '', '', '', '', '');
INSERT INTO `alex_livre_img_verif_add` VALUES ('3XKuRMQcd4', '1294236064', 'BQUV', '', '', '', '', '', '', '');

